'/***
'*io.h - declarations for low-level file handling and I/O functions
'*
'*       Copyright (c) 1985-1997, Microsoft Corporation. All rights reserved.
'*
'*Purpose:
'*       This file contains the function declarations for the low-level
'*       file handling and I/O functions.
'*
'*       [Public]
'*
'****/

#If Not %Def(%IO_INC)
    %IO_INC = 1

#Include "fcntl.inc"

'/*
' * Currently, all MS C compilers for Win32 platforms default to 8 byte
' * alignment.
' */
'#pragma pack(push,8)

'typedef unsigned short wchar_t;
'typedef long time_t;            /* time value */
'typedef unsigned long _fsize_t; /* Could be 64 bits for Win32 */

#If Not %Def(%FINDDATA_T_DEFINED)
%FINDDATA_T_DEFINED = 1

Type finddata_t
   Attrib      As Dword          ' unsigned
   time_create As Long           ' time_t /* -1 for FAT file systems */
   time_access As Long           ' time_t /* -1 for FAT file systems */
   time_write  As Long           ' time_t
   Size        As Dword          ' _fsize_t
   Name        As Asciiz * 260   ' char
End Type

'#if     _INTEGRAL_MAX_BITS >= 64
Type finddatai64_t
   Attrib      As Dword          ' unsigned
   time_create As Long           ' time_t /* -1 for FAT file systems */
   time_access As Long           ' time_t /* -1 for FAT file systems */
   time_write  As Long           ' time_t
   Size        As Quad           ' __int64
   Name        As Asciiz * 260   ' char
End Type
'#endif

#EndIf

#If Not %Def(%WFINDDATA_T_DEFINED)
%WFINDDATA_T_DEFINED = 1

Type wfinddata_t
   Attrib      As Dword              ' unsigned
   time_create As Long               ' time_t /* -1 for FAT file systems */
   time_access As Long               ' time_t /* -1 for FAT file systems */
   time_write  As Long               ' time_t
   Size        As Dword              ' _fsize_t
   Name        As String * 260 * 2   ' wchar_t
End Type

'#if     _INTEGRAL_MAX_BITS >= 64
Type wfinddatai64_t
   Attrib      As Dword              ' unsigned
   time_create As Long               ' time_t /* -1 for FAT file systems */
   time_access As Long               ' time_t /* -1 for FAT file systems */
   time_write  As Long               ' time_t
   Size        As Quad               ' __int64
   Name        As String * 260 * 2   ' wchar_t
End Type
'#endif

#EndIf

'/* File attribute constants for _findfirst() */

%A_NORMAL       = &H00???    ' /* Normal file - No read/write restrictions */
%A_RDONLY       = &H01???    ' /* Read only file */
%A_HIDDEN       = &H02???    ' /* Hidden file */
%A_SYSTEM       = &H04???    ' /* System file */
%A_SUBDIR       = &H10???    ' /* Subdirectory */
%A_ARCH         = &H20???    ' /* Archive file */

'/* function prototypes */

'_CRTIMP int __cdecl _access(const char *, int);
Declare Function access_ CDecl Lib "msvcrt.dll" Alias "_access" ( _
   ByRef Asciiz, _                          ' const char *path
   ByVal Long _                             ' int mode
   ) As Long                                ' int

'_CRTIMP int __cdecl _chmod(const char *, int);
Declare Function chmod_ CDecl Lib "msvcrt.dll" Alias "_chmod" ( _
   ByRef Asciiz, _                          ' const char *filename
   ByVal Long _                             ' int pmode
   ) As Long                                ' int

'_CRTIMP int __cdecl _chsize(int, long);
Declare Function chsize_ CDecl Lib "msvcrt.dll" Alias "_chsize" ( _
   ByVal Long, _                            ' int fd
   ByVal Long _                             ' int size
   ) As Long                                ' int

'_CRTIMP int __cdecl _close(int);
Declare Function close_ CDecl Lib "msvcrt.dll" Alias "_close" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' int

'_CRTIMP int __cdecl _commit(int);
Declare Function commit_ CDecl Lib "msvcrt.dll" Alias "_commit" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' int

'_CRTIMP int __cdecl _creat(const char *, int);
Declare Function creat_ CDecl Lib "msvcrt.dll" Alias "_creat" ( _
   ByRef Asciiz, _                          ' const char *filename
   ByVal Long _                             ' int pmode
   ) As Long                                ' int

'_CRTIMP int __cdecl _dup(int);
Declare Function dup_ CDecl Lib "msvcrt.dll" Alias "_dup" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' int

'_CRTIMP int __cdecl _dup2(int, int);
Declare Function dup2_ CDecl Lib "msvcrt.dll" Alias "_dup2" ( _
   ByVal Long, _                            ' int fd1
   ByVal Long _                             ' int fd2
   ) As Long                                ' int

'_CRTIMP int __cdecl _eof(int);
Declare Function eof_ CDecl Lib "msvcrt.dll" Alias "_eof" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' int

'_CRTIMP long __cdecl _filelength(int);
Declare Function filelength_ CDecl Lib "msvcrt.dll" Alias "_filelength" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' long

'_CRTIMP long __cdecl _findfirst(const char *, struct _finddata_t *);
Declare Function findfirst_ CDecl Lib "msvcrt.dll" Alias "_findfirst" ( _
   ByRef Asciiz, _                          ' const char *filespec
   ByRef finddata_t _                       ' struct _finddata_t *fileinfo
   ) As Long                                ' long

'_CRTIMP int __cdecl _findnext(long, struct _finddata_t *);
Declare Function findnext_ CDecl Lib "msvcrt.dll" Alias "_findnext" ( _
   ByVal Long, _                            ' long handle
   ByRef finddata_t _                       ' struct _finddata_t *fileinfo
   ) As Long                                ' int

'_CRTIMP int __cdecl _findclose(long);
Declare Function findclose_ CDecl Lib "msvcrt.dll" Alias "_findclose" ( _
   ByVal Long _                             ' long handle
   ) As Long                                ' int

'_CRTIMP int __cdecl _isatty(int);
Declare Function isatty_ CDecl Lib "msvcrt.dll" Alias "_isatty" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' int

'_CRTIMP int __cdecl _locking(int, int, long);
Declare Function locking_ CDecl Lib "msvcrt.dll" Alias "_locking" ( _
   ByVal Long, _                            ' int fd
   ByVal Long, _                            ' int mode
   ByVal Long _                             ' long nbytes
   ) As Long                                ' int

'_CRTIMP long __cdecl _lseek(int, long, int);
Declare Function lseek_ CDecl Lib "msvcrt.dll" Alias "_lseek" ( _
   ByVal Long, _                            ' int fd
   ByVal Long, _                            ' long offset
   ByVal Long _                             ' int origin
   ) As Long                                ' long

'_CRTIMP char * __cdecl _mktemp(char *);
Declare Function mktemp_ CDecl Lib "msvcrt.dll" Alias "_mktemp" ( _
   ByRef Asciiz _                           ' char *template
   ) As Long                                ' char *

'_CRTIMP int __cdecl _open(const char *, int, ...);
Declare Function open_ CDecl Lib "msvcrt.dll" Alias "_open" ( _
   ByRef Asciiz, _                          ' const char *filename
   ByVal Long, _                            ' int oflag
   Optional ByVal Long _                    ' pmode
   ) As Long                                ' int

'_CRTIMP int __cdecl _pipe(int *, unsigned int, int);
Declare Function pipe_ CDecl Lib "msvcrt.dll" Alias "_pipe" ( _
   ByRef Long, _                            ' int *pfds
   ByVal Dword, _                           ' unsigned int psize
   ByVal Long _                             ' int textmode
   ) As Long                                ' int

'_CRTIMP int __cdecl _read(int, void *, unsigned int);
Declare Function read_ CDecl Lib "msvcrt.dll" Alias "_read" ( _
   ByVal Long, _                            ' int fd
   ByRef Any, _                             ' void *buffer
   ByVal Dword _                            ' unsigned int count
   ) As Long                                ' int

'_CRTIMP int __cdecl remove(const char *);
' Note: Already declared as remove in stdio.inc
Declare Function remove_ CDecl Lib "msvcrt.dll" Alias "remove" ( _
   ByRef Asciiz _                           ' const char *path
   ) As Long                                ' int

'_CRTIMP int __cdecl rename(const char *, const char *);
' Note: Already declared as rename in stdio.inc
Declare Function rename_ CDecl Lib "msvcrt.dll" Alias "rename" ( _
   ByRef Asciiz, _                          ' const char *oldname
   ByRef Asciiz _                           ' const char *newname
   ) As Long                                ' int

'_CRTIMP int __cdecl _setmode(int, int);
Declare Function setmode_ CDecl Lib "msvcrt.dll" Alias "_setmode" ( _
   ByVal Long, _                            ' int fd
   ByVal Long _                             ' int mode
   ) As Long                                ' int

'_CRTIMP int __cdecl _sopen(const char *, int, int, ...);
Declare Function sopen_ CDecl Lib "msvcrt.dll" Alias "_sopen" ( _
   ByRef Asciiz, _                          ' const char *filename
   ByVal Long, _                            ' int oflag
   ByVal Long, _                            ' int shflag
   Optional ByVal Long _                    ' pmode
   ) As Long                                ' int

'_CRTIMP long __cdecl _tell(int);
Declare Function tell_ CDecl Lib "msvcrt.dll" Alias "_tell" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' long

'_CRTIMP int __cdecl _umask(int);
Declare Function umask_ CDecl Lib "msvcrt.dll" Alias "_umask" ( _
   ByVal Long _                             ' int pmode
   ) As Long                                ' long

'_CRTIMP int __cdecl _unlink(const char *);
' Note: already declared in stdio.inc as unlink.
Declare Function unlink_ CDecl Lib "msvcrt.dll" Alias "_unlink" ( _
   ByRef Asciiz _                           ' const char *filename
   ) As Long                                ' int

'_CRTIMP int __cdecl _write(int, const void *, unsigned int);
Declare Function write_ CDecl Lib "msvcrt.dll" Alias "_write" ( _
   ByVal Long, _                            ' int fd
   ByRef Any, _                             ' const void *buffer
   ByVal Dword _                            ' unsigned int count
   ) As Long                                ' int

'#if     _INTEGRAL_MAX_BITS >= 64
'_CRTIMP __int64 __cdecl _filelengthi64(int);
' Note: C compilers and PB differ in the method to return quads.
'DECLARE FUNCTION filelengthi64_ CDECL LIB "msvcrt.dll" ALIAS "_filelengthi64" ( _
'   BYVAL LONG _                             ' int fd
'   ) AS QUAD                                ' __int64

'_CRTIMP long __cdecl _findfirsti64(const char *, struct _finddatai64_t *);
Declare Function findfirsti64_ CDecl Lib "msvcrt.dll" Alias "_findfirsti64" ( _
   ByRef Asciiz, _                          ' const char *filespec
   ByRef finddatai64_t _                    ' struct _finddatai64_t *fileinfo
   ) As Long                                ' long

'_CRTIMP int __cdecl _findnexti64(long, struct _finddatai64_t *);
Declare Function findnexti64_ CDecl Lib "msvcrt.dll" Alias "_findnexti64" ( _
   ByVal Long, _                            ' long handle
   ByRef finddatai64_t _                    ' struct _finddatai64_t *fileinfo
   ) As Long                                ' int

'_CRTIMP __int64 __cdecl _lseeki64(int, __int64, int);
' Note: C compilers and PB differ in the method to return quads.
'DECLARE FUNCTION lseeki64_ CDECL LIB "msvcrt.dll" ALIAS "_lseeki64" ( _
'   BYVAL LONG, _                            ' int fd
'   BYVAL QUAD, _                            ' __int64 offset
'   BYVAL LONG _                             ' int origin
'   ) AS QUAD                                ' __int64

'_CRTIMP __int64 __cdecl _telli64(int);
' Note: C compilers and PB differ in the method to return quads.
'DECLARE FUNCTION telli64_ CDECL LIB "msvcrt.dll" ALIAS "_telli64" ( _
'   BYVAL LONG _                             ' int fd
'   ) AS QUAD                                ' __int64

'#endif

#If Not %Def(%WIO_DEFINED)
%WIO_DEFINED = 1

'/* wide function prototypes, also declared in wchar.h  */

'_CRTIMP int __cdecl _waccess(const wchar_t *, int);
Declare Function waccess_ CDecl Lib "msvcrt.dll" Alias "_waccess" ( _
   ByVal Dword, _                           ' const wchar_t *path
   ByVal Long _                             ' int mode
   ) As Long                                ' int

'_CRTIMP int __cdecl _wchmod(const wchar_t *, int);
Declare Function wchmod_ CDecl Lib "msvcrt.dll" Alias "_wchmod" ( _
   ByVal Dword, _                           ' const wchar_t *filename
   ByVal Long _                             ' int pmode
   ) As Long                                ' int

'_CRTIMP int __cdecl _wcreat(const wchar_t *, int);
Declare Function wcreat_ CDecl Lib "msvcrt.dll" Alias "_wcreat" ( _
   ByVal Dword, _                           ' const wchar_t *filename
   ByVal Long _                             ' int pmode
   ) As Long                                ' int

'_CRTIMP long __cdecl _wfindfirst(const wchar_t *, struct _wfinddata_t *);
Declare Function wfindfirst_ CDecl Lib "msvcrt.dll" Alias "_wfindfirst" ( _
   ByVal Dword, _                           ' const wchar_t *filespec
   ByRef wfinddata_t _                      ' struct _wfinddata_t *fileinfo
   ) As Long                                ' long

'_CRTIMP int __cdecl _wfindnext(long, struct _wfinddata_t *);
Declare Function wfindnext_ CDecl Lib "msvcrt.dll" Alias "_wfindnext" ( _
   ByVal Long, _                            ' long handle
   ByRef wfinddata_t _                      ' struct _wfinddata_t *fileinfo
   ) As Long                                ' int

'_CRTIMP int __cdecl _wunlink(const wchar_t *);
Declare Function wunlink_ CDecl Lib "msvcrt.dll" Alias "_wunlink" ( _
   ByVal Dword _                            ' const wchar_t *filename
   ) As Long                                ' int

'_CRTIMP int __cdecl _wrename(const wchar_t *, const wchar_t *);
Declare Function wrename_ CDecl Lib "msvcrt.dll" Alias "_wrename" ( _
   ByVal Dword, _                           ' const wchar_t *oldname
   ByVal Dword _                            ' const wchar_t *newname
   ) As Long                                ' int

'_CRTIMP int __cdecl _wopen(const wchar_t *, int, ...);
Declare Function wopen_ CDecl Lib "msvcrt.dll" Alias "_wopen" ( _
   ByVal Dword, _                           ' const wchar_t *filename
   ByVal Long, _                            ' int oflag
   Optional ByVal Long _                    ' pmode
   ) As Long                                ' int

'_CRTIMP int __cdecl _wsopen(const wchar_t *, int, int, ...);
Declare Function wsopen_ CDecl Lib "msvcrt.dll" Alias "_wsopen" ( _
   ByVal Dword, _                           ' const wchar_t *filename
   ByVal Long, _                            ' int oflag
   ByVal Long, _                            ' int shflag
   Optional ByVal Long _                    ' pmode
   ) As Long                                ' int

'_CRTIMP wchar_t * __cdecl _wmktemp(wchar_t *);
Declare Function wmktemp_ CDecl Lib "msvcrt.dll" Alias "_wmktemp" ( _
   ByRef Any _                              ' wchar_t *template
   ) As Dword                               ' wchar_t *

'#if     _INTEGRAL_MAX_BITS >= 64
'_CRTIMP long __cdecl _wfindfirsti64(const wchar_t *, struct _wfinddatai64_t *);
Declare Function wfindfirsti64_ CDecl Lib "msvcrt.dll" Alias "_wfindfirsti64" ( _
   ByRef Asciiz, _                          ' const char *filespec
   ByRef wfinddatai64_t _                   ' struct _wfinddatai64_t *fileinfo
   ) As Long                                ' long

'_CRTIMP int __cdecl _wfindnexti64(long, struct _wfinddatai64_t *);
Declare Function wfindnexti64_ CDecl Lib "msvcrt.dll" Alias "_wfindnexti64" ( _
   ByVal Long, _                            ' long handle
   ByRef wfinddatai64_t _                   ' struct _wfinddatai64_t *fileinfo
   ) As Long                                ' int
'#endif

#EndIf


'_CRTIMP long __cdecl _get_osfhandle(int);
Declare Function get_osfhandle CDecl Lib "msvcrt.dll" Alias "_get_osfhandle" ( _
   ByVal Long _                             ' int fd
   ) As Long                                ' long

'_CRTIMP int __cdecl _open_osfhandle(long, int);
Declare Function open_osfhandle CDecl Lib "msvcrt.dll" Alias "_open_osfhandle" ( _
   ByVal Long, _                            ' long osfhandle
   ByVal Long _                             ' int flags
   ) As Long                                ' int

'#pragma pack(pop)

#EndIf   ' #IF NOT %DEF(%IO_INC)